define(['angular', 'angularMocks', 'DirectSchedulingController', 'angularUiBootstrap', 'lodash'], function(angular, mocks) {
	'use strict';

	describe('The Direct Scheduling controller', function () {
		var controller, 
			scope,
			modalServiceMock,
			focusServiceMock,
			connectionErrorServiceMock,
			formatterMock,
			directSchedulingServiceMock,
			validationSummaryMock,
			activeInstitutionMock;

		beforeEach( function () {
			module('angularTemplateApp');

			modalServiceMock = jasmine.createSpyObj('modalService', ['showModal']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain', 'focusPrimary']);
			connectionErrorServiceMock = jasmine.createSpyObj('connectionErrorService', ['showServerErrorMsg']);
			formatterMock = jasmine.createSpyObj('formatter', ['toDashCase']);
			directSchedulingServiceMock = jasmine.createSpyObj('DirectSchedulingService', ['fetch', 'save']);
			validationSummaryMock = jasmine.createSpyObj('validationSummary', ['requiredValidate', 'clear', 'summarizeAsync']);
			activeInstitutionMock = {divisionName:"mock institution",childName:'501'};

			module(function($provide){
				$provide.value('modalService', modalServiceMock);
				$provide.value('focusService', focusServiceMock);
				$provide.value('connectionErrorService', connectionErrorServiceMock);
				$provide.value('formatter', formatterMock);
				$provide.value('DirectSchedulingService', directSchedulingServiceMock);
				$provide.value('activeInstitution', activeInstitutionMock);
			});

			inject(function($controller, $rootScope, $q) {
				scope = $rootScope.$new();

				modalServiceMock.showModal.andCallFake( function() {
					return {
						then: function(callback) { return callback(); }
					};
				} );

				directSchedulingServiceMock.fetch.andCallFake( function() {
					var promise = $q.defer();
					var response = {
						status: 200,
						data: {
							id: '501',
							coreSettings:[{
								"typeOfCare": "AUDIOLOGY",
								"patientHistoryRequired": "",
								"patientHistoryDuration": 0,
								"canCancel": 'true'
							}]
						}
					};
					promise.resolve({
						response: response
					});
					promise.then = function(callback) { return callback(response); };
					return promise;
				} );

				directSchedulingServiceMock.save.andCallFake( function(data) {
					var promise = $q.defer();
					var response = {
						status: 200,
						data: data
					};
					promise.resolve({
						response: response
					});
					promise.then = function(callback) { return callback(response); };
					return promise;
				} );

				validationSummaryMock.requiredValidate.andCallFake( function(){
					return {
						then: function(callback) { return callback(); }
					};
				} );

				controller = $controller('DirectSchedulingController', {$scope: scope});

				 scope.directSchedulingForm = {
					validationSummary: validationSummaryMock,
					$setPristine: function (){},
					$setSubmitted: function (){}
				};
			});
		});

		it('should reset the form to the data that was last saved', function(){
			expect(scope.directBooking).toEqual({
				id: '501',
				coreSettings:[{
					"typeOfCare": "AUDIOLOGY",
					"patientHistoryRequired": "",
					"patientHistoryDuration": 0,
					"canCancel": true
				}]
			});
			expect(scope.lastSavedDirectBooking).toEqual(scope.directBooking);

			scope.reset();
			expect(scope.lastSavedDirectBooking.coreSettings[0]).toEqual({
				"typeOfCare": "AUDIOLOGY",
				"patientHistoryRequired": "",
				"patientHistoryDuration": 0,
				"canCancel": true
			});
			expect(scope.directBooking).toEqual(scope.lastSavedDirectBooking);
		});

		it('should save the form data', function(){
			scope.directBooking = {
				id: '501',
				coreSettings: [{
					"typeOfCare": "AUDIOLOGY",
					"patientHistoryRequired": "No",
					"patientHistoryDuration": 2,
					"canCancel": true
				}]
			};
			scope.save();
			expect(directSchedulingServiceMock.save).toHaveBeenCalledWith(scope.directBooking, '501');
			expect(modalServiceMock.showModal).toHaveBeenCalled();
			expect(validationSummaryMock.summarizeAsync).toHaveBeenCalled();

			expect(scope.directBooking.coreSettings[0]).toEqual({
				'typeOfCare': 'AUDIOLOGY',
				'patientHistoryRequired': 'No',
				'patientHistoryDuration': 2,
				'canCancel': true
			});

			expect(scope.lastSavedDirectBooking).toEqual(scope.directBooking);
		});

		it('should present "Any Veteran" option for primary care', function () {
			var options = scope.getSupportedMenuOptions({id: '323'});
			var optionValues = _.map(options, 'value');
			expect(optionValues.length).toBe(1);
			expect(optionValues).toContain("No"); // "Any Veteran" option
		});

		it('should present "Any Veteran" and "Based Upon Time Frame" options for any other type of care', function () {
			var options = scope.getSupportedMenuOptions({id: '408'});
			var optionValues = _.map(options, 'value');
			expect(optionValues.length).toBe(2);
			expect(optionValues).toContain("No"); // "Any Veteran" option
			expect(optionValues).toContain("Yes"); // "Based Upon Time Frame" option
		});
	});
});
